package music;

import java.io.Serializable;

/**
 * Write a description of class Song here.
 *
 * @author (your name)
 * @version (a version number or a date)
 */
public class Song implements Serializable {
    
    // private static String definition;
    public static String definition;
    
    private String title;
    private int time;
    private String lyrics;
    
    
    static {
        definition = "A nice piece of music";
    }
    
    public Song(String title, int time, String lyrics) {
		super();
		this.title = title;
		this.time = time;
		this.lyrics = lyrics;
	}

	private static final long serialVersionUID = 5L;
    
    public Song(String title, int time) {
        this.title = title;
        this.time = time;
    }
    
    public Song() {
    }
    
    @Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + time;
		result = prime * result + ((title == null) ? 0 : title.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Song other = (Song) obj;
		if (time != other.time)
			return false;
		if (title == null) {
			if (other.title != null)
				return false;
		} else if (!title.equals(other.title))
			return false;
		return true;
	}

	public static void explain() {
        System.out.println("Songs are nice");
        // getTime();       // no, you cannot call a non-static method from a static context
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public String getTitle() {
        return this.title;
    }
    
    public void setTime(int time) {
        // if ((time < 20) || (time > 10000)) {
            // System.out.println("Error: song duration wrong");
            // return;
        // }
        // this.time = time;
        if (!((time < 20) || (time > 10000))) {
            this.time = time;
        } else {
            System.out.println("Error: song duration wrong");
        }
    }
    
    public int getTime() {
        return this.time;
    }
    
    public void setDefinition(String definition) {
        this.definition = definition;
    }
    
    public String getDefinition() {
        return this.definition;
    }

	public String getLyrics() {
		return lyrics;
	}

	public void setLyrics(String lyrics) {
		this.lyrics = lyrics;
	}
    
}
